/*  Command script executed prior to launch official script  */
/*  Used to synchronize builtins environment                 */

//! @li 2009/12/02 P. CHAPELET Def27960 : Robustness
//! @li 2009/08/03 P. CHAPELET Evo4983  : Script Robustness
//! @li 2009/02/11 P. CHAPELET Def25786 : Manage good popups at the end of upgrade
//! @li 2007/05/11 B. DAVID EVO #3293   : POI upgrade

/*** TYPES ***/

typedef int  STATUS;
typedef int  BOOL;
typedef void *MODULE_ID;

/*** CONSTANTS ***/

#define TRUE     (1)
#define FALSE    (0)
#define OK       (0)
#define ERROR    (-1)
#define NULL     (void*) 0

#define O_RDONLY (0)
#define O_RDWR   (2)

#define LOAD_NO_SYMBOLS         2
#define LOAD_LOCAL_SYMBOLS      4
#define LOAD_GLOBAL_SYMBOLS     8
#define LOAD_ALL_SYMBOLS        12

#define BUILTINS_FILE_NORMAL    "/UPG/builtinsRNEG.out"
#define OFFICIAL_UPG_SCRIPT     "/UPG/POI_UPGRADE_SUB_RNEG.CMD"

#define MAX_PATH_LENGTH         200
#define MAX_LEN_SOURCE_DRIVE    5
#define WAIT_SHOW_CD_PROBLEM    2000

/*** EXTERN FUNCTION DEFINITIONS ***/

int EiC_ExeFile(int argc, char **argv);
MODULE_ID LoadAndExecuteFile (char*         p_root,
                          char*         p_file_name,
                          int           p_ld_symb,
                          int           p_invalid,
                          unsigned int  p_delay);
int logMsg (char *str,int p1,int p2,int p3,int p4,int p5,int p6);
STATUS strcpy (char* target, char* source);
STATUS strcat (char* target, char* source);
STATUS strlen (char* str);
int strcmp (char* str1, char* str2);
STATUS ShowCDProblem(void);
STATUS ClearScreen(void);
STATUS UPGCDEject(void);
STATUS taskDelay (int ticks);

/*** MAIN ***/

int main ( int argc, char **argv )
{
  STATUS    l_script_status = ERROR;
  char     *l_pTab[3];
  char      l_pScriptFile[MAX_PATH_LENGTH];
  char      l_pSourceDrive[MAX_PATH_LENGTH];
  char      l_pUpgType[MAX_PATH_LENGTH];

  strcpy ( l_pSourceDrive, argv[1] );
  l_pTab[1] = l_pSourceDrive;
  if ((strlen (l_pTab[1]) <= MAX_LEN_SOURCE_DRIVE) && (l_pTab[1][0] == '/'))
  {
    strcpy ( l_pUpgType, argv[2] );
    l_pTab[2] = l_pUpgType;

    strcpy ( l_pScriptFile, l_pSourceDrive );
    strcat ( l_pScriptFile, OFFICIAL_UPG_SCRIPT );
    l_pTab[0] = l_pScriptFile;

    // Builtins loading
    if ( NULL != LoadAndExecuteFile (l_pTab[1],
                                     BUILTINS_FILE_NORMAL,
                                     LOAD_GLOBAL_SYMBOLS,
                                     ERROR,
                                     0))
    {
      if ( OK == EiC_ExeFile (3, l_pTab) )
      {
        l_script_status = OK;
      }
      else
      {
        logMsg ( "EiC_ExeFile error on %s\n", (char*)l_pTab[1],0,0,0,0,0);
      }
    }
    else
    {
      logMsg ( "LoadAndExecuteFile error on %s BUILTINS_FILE_NORMAL\n",
               (char*)l_pTab[1], 0,0,0,0,0 );
    }
  }
  else
  {
    logMsg ( "ERROR : strlen (l_pTab[1]) > %d\n", MAX_LEN_SOURCE_DRIVE,0,0,0,0,0);
  }

  if (ERROR == l_script_status)
  {
    ShowCDProblem ();
    UPGCDEject ();
    taskDelay (WAIT_SHOW_CD_PROBLEM);
    ClearScreen ();
  }

  return l_script_status;
}

